@echo -off
set pkgver 2.09.100.04_BMC_disabled_Transitional

BoardVersion.efi

if %lasterror% == 0xA1 then
   echo "BoardRevision: A1"
   set capver ".A1."
else   
   if %lasterror% == 0xA2 then
      echo "BoardRevision: A2"
      set capver "."
   else
      if %1 == A1 then
         echo "User Entered BoardRevision: A1"
         set capver ".A1."
      else
         if %1 == A2 then
            echo "User Entered BoardRevision: A2"
            set capver "."
         else
            echo "Unable to detect the board revision automatically."
            echo "Please enter correct board revision."
            goto end
         endif
      endif
   endif
endif 

echo "Update SCP"
CapsuleApp.efi ComHpcAlt_scp_%pkgver%%capver%cap
if %lasterror% == 0x0 then
   echo "Update EDK2"
   CapsuleApp.efi ComHpcAlt_tianocore_atf_%pkgver%%capver%cap
   if %lasterror% == 0x0 then
      echo "Reboot to firmware UI"
      FwUi.efi
   else
      echo "The specified board revision firmware file is not available."
      goto end
   endif
else
   echo "Unable to detect the board revision automatically."
   if %1 == A1 then 
      echo "User Entered BoardRevision: A1"
      set capver ".A1."
   else
      if %1 == A2 then
         echo "User Entered BoardRevision: A2"
         set capver "."
      else 
         echo "The specified board revision firmware file is not available."
         goto end
      endif
   endif
endif

echo "Update SCP"
CapsuleApp.efi ComHpcAlt_scp_%pkgver%%capver%cap
if %lasterror% == 0x0 then
   echo "Update EDK2"
   CapsuleApp.efi ComHpcAlt_tianocore_atf_%pkgver%%capver%cap
   if %lasterror% == 0x0 then
      echo "Reboot to firmware UI"
      FwUi.efi
   else
      echo "The specified board revision firmware file is not available."
      goto end
   endif
else
   echo "Please enter correct board revision."
   echo "The specified board revision firmware file is not available."
   goto end
endif


:end
echo " "
echo "To update the firmware manually follow the below format:"
echo "    Capsule_Transitional.nsh <Board revision>"
echo "Example:"
echo "    Capsule_Transitional.nsh A1 (or) Capsule_Transitional.nsh A2"
echo " "
echo "_______________________________________________________________________________"
echo " "
echo "WARNING: Please be cautious while updating the firmware manually."
echo "Ensure the correct board revision is provided to avoid potential system issues."
echo "_______________________________________________________________________________"
